***************************************************************
*BPEA 2016 public do file
*Cavallo, Cruces and Perez-Truglia
*"Learning from potentially biased statistics
*Household Inflation Perceptions and Expectations in Argentina"
*Figures 2 and 3 
*All other figures in separate do and data files
***************************************************************
use "BPEA_Cavallo_Cruces_Perez-Truglia_2016_Figs 2-3.dta", clear
set more off

label var pi_indec "Official Inflation (Previous 12 Months)"
label var pi_bsas_city "Unofficial Inflation (Previous 12 Months)"
label var median "Inflation Expectations, Next 12 Months (Median)"
label var mean "Inflation Expectations, Next 12 Months (Mean)"

sort month


*Figure 3
label var pi_indec "Official Inflation Rate"
label var pi_bsas_city "Unofficial Inflation (BA City)"
label var pi_cqp "Unofficial Inflation (Provincial Index)"
label var pi_pricestats "Unofficial Inflation (Pricestats)" 
label var pi_congreso "Unofficial Inflation (Congress Average)" 

global start 2004m1
global end 2013m12

graph twoway (tsline pi_indec pi_pricestats pi_cqp  pi_bsas_city  pi_congreso  if month>=tm($start)& month<=tm($end), /*
*/ tline(564.5) lcolor(navy cranberry dkgreen dkorange teal) lpattern(solid longdash shortdash longdash_dot shortdash_dot)/*
*/ lwidth(medthick medthick medthick medthick medthick medthick medthick) xtitle("") scheme(s1mono) /*
*/ tlabel(2004m7(12)2013m7,format(%tmCY) noticks) ttick(2004m1(12)2014m1, tlength(*1.5))/*
*/ yscale(range(0 35)) ylabel(0(10)35))/*
*/ ,legend(size(small) order(1 2 3 4 5 - "(All: Previous 12 Months)"))

graph export "Actual_Perceived_Pricestats_2004.eps", replace
graph export "Actual_Perceived_Pricestats_2004.png", replace

*Figure 3
global start 2006m1
global end 2013m12
graph twoway (tsline pi_indec pi_pricestats  qmedian if month>=tm($start)& month<=tm($end), tline(564.5) lcolor(navy cranberry khaki sienna) lpattern(solid longdash shortdash longdash_dot) lwidth(medthick medthick medthick medthick) xtitle("") scheme(s1mono) tlabel(2006m7(12)2013m7,format(%tmCY) noticks) ttick(2006m1(12)2014m1, tlength(*1.5))  yscale(range(0 40)) ylabel(0(10)40)),  legend(size(small) label(1 "Official Inflation Rate" "Previous 12 Months") label (2 "Unofficial Inflation Rate" "Previous 12 Months")  label(3 "Inflation Expectations" "Next 12 Months (Median)") label(4 "Inflation Expectations" "Next 12 Months (Mean)"))

graph export "Actual_Perceived_Multiple_2006.eps", replace
graph export "Actual_Perceived_Multiple_2006.png", replace

